/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.AppWindowEvent;
import com.cisco.pt.ipc.events.AppWindowEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.ui.AppWindow;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppWindowEventRegistry
extends IPCEventRegistry {
    protected Set<AppWindowEventListener> globalListeners = new HashSet<AppWindowEventListener>();
    protected Map<String, Set<AppWindowEventListener>> specificObjectListeners = new HashMap<String, Set<AppWindowEventListener>>();
    private static Log logger = LogFactory.getLog(AppWindowEventRegistry.class);

    public AppWindowEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "AppWindow";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        AppWindowEvent evt = null;
        if (eventName.equalsIgnoreCase("fileNewed")) {
            evt = new AppWindowEvent.FileNewed(event);
        } else if (eventName.equalsIgnoreCase("fileOpened")) {
            evt = new AppWindowEvent.FileOpened(event);
        } else if (eventName.equalsIgnoreCase("fileSaved")) {
            evt = new AppWindowEvent.FileSaved(event);
        } else if (eventName.equalsIgnoreCase("fileSaveDone")) {
            evt = new AppWindowEvent.FileSaveDone(event);
        } else if (eventName.equalsIgnoreCase("fileSaveToBytesDone")) {
            evt = new AppWindowEvent.FileSaveToBytesDone(event);
        } else if (eventName.equalsIgnoreCase("appExit")) {
            evt = new AppWindowEvent.AppExit(event);
        } else if (eventName.equalsIgnoreCase("lockedInterfaceInvoked")) {
            evt = new AppWindowEvent.LockedInterfaceInvoked(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (AppWindowEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<AppWindowEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (AppWindowEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(AppWindowEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("fileNewed");
                this.register("fileOpened");
                this.register("fileSaved");
                this.register("fileSaveDone");
                this.register("fileSaveToBytesDone");
                this.register("appExit");
                this.register("lockedInterfaceInvoked");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(AppWindowEventListener listener, AppWindow objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<AppWindowEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<AppWindowEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "fileNewed");
                this.register(uuid, "fileOpened");
                this.register(uuid, "fileSaved");
                this.register(uuid, "fileSaveDone");
                this.register(uuid, "fileSaveToBytesDone");
                this.register(uuid, "appExit");
                this.register(uuid, "lockedInterfaceInvoked");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(AppWindowEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("fileNewed");
                this.deregister("fileOpened");
                this.deregister("fileSaved");
                this.deregister("fileSaveDone");
                this.deregister("fileSaveToBytesDone");
                this.deregister("appExit");
                this.deregister("lockedInterfaceInvoked");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(AppWindowEventListener listener, AppWindow objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<AppWindowEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "fileNewed");
            this.deregister(uuid, "fileOpened");
            this.deregister(uuid, "fileSaved");
            this.deregister(uuid, "fileSaveDone");
            this.deregister(uuid, "fileSaveToBytesDone");
            this.deregister(uuid, "appExit");
            this.deregister(uuid, "lockedInterfaceInvoked");
            specificListeners.remove(listener);
        }
    }

    public void addListener(AppWindowEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(AppWindowEventListener listener, AppWindow objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(AppWindowEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(AppWindowEventListener listener, AppWindow objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

